VERSION 5.00
Object = "{DFEB0DA3-D648-11D4-9C5F-EA48B7E9393D}#1.0#0"; "tvc.ocx"
Begin VB.Form frmCH4_VB 
   ClientHeight    =   3492
   ClientLeft      =   13680
   ClientTop       =   -2820
   ClientWidth     =   5268
   LinkTopic       =   "Form1"
   ScaleHeight     =   3492
   ScaleWidth      =   5268
   Begin TVCLib.Tvc Tvc1 
      Left            =   1560
      Top             =   3000
      _Version        =   65536
      _ExtentX        =   847
      _ExtentY        =   847
      _StockProps     =   0
      VisaDescriptor  =   "GPIB8::1::INSTR"
   End
   Begin VB.Frame Frame2 
      Caption         =   "Waveform Data"
      Height          =   3135
      Left            =   120
      TabIndex        =   0
      Top             =   120
      Width           =   4935
      Begin VB.ListBox lstWF 
         Height          =   2544
         ItemData        =   "frmCH4_VB.frx":0000
         Left            =   2640
         List            =   "frmCH4_VB.frx":0002
         TabIndex        =   4
         Top             =   240
         Width           =   1935
      End
      Begin VB.CheckBox chkDisplayWF 
         Caption         =   "Display Wave Form Values"
         Height          =   375
         Left            =   120
         TabIndex        =   3
         Top             =   1800
         Width           =   2295
      End
      Begin VB.CommandButton cmdGetWaveForm 
         Caption         =   "Get WaveForm"
         Height          =   375
         Left            =   120
         TabIndex        =   2
         Top             =   2280
         Width           =   1335
      End
      Begin VB.CommandButton cmdClear 
         Caption         =   "Clear"
         Height          =   375
         Left            =   1560
         TabIndex        =   1
         Top             =   2280
         Width           =   975
      End
      Begin VB.Label lblInterval 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   1320
         TabIndex        =   10
         Top             =   720
         Width           =   975
      End
      Begin VB.Label Label2 
         Caption         =   "Interval"
         Height          =   255
         Left            =   120
         TabIndex        =   9
         Top             =   840
         Width           =   855
      End
      Begin VB.Label lblRecLength 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   1320
         TabIndex        =   8
         Top             =   240
         Width           =   975
      End
      Begin VB.Label Label4 
         Caption         =   "Record Length"
         Height          =   255
         Left            =   120
         TabIndex        =   7
         Top             =   360
         Width           =   1095
      End
      Begin VB.Label lblTrigPos 
         BorderStyle     =   1  'Fixed Single
         Height          =   375
         Left            =   1320
         TabIndex        =   6
         Top             =   1200
         Width           =   975
      End
      Begin VB.Label Label6 
         Caption         =   "Trigger Position"
         Height          =   255
         Left            =   120
         TabIndex        =   5
         Top             =   1320
         Width           =   1215
      End
   End
End
Attribute VB_Name = "frmCH4_VB"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

Private Sub cmdClear_Click()
    ' clear controls which display waveform data

   lstWF.Clear
   lblRecLength.Caption = ""
   lblInterval.Caption = ""
   lblTrigPos.Caption = ""
   
End Sub

Private Sub cmdGetWaveForm_Click()
  ' declare variables
   Dim arrWF As Variant 'array variable which will hold waveform values
   Dim xinc As Double ' variable which will hold the x axis increment
   Dim trigpos As Long ' variable which hold the timing trigger position
   Dim i As Long  ' counter variable
   Dim hUnits As String, vUnits As String   ' variables for returning unit types
   
   On Error GoTo cmdGetWFMErr
   
   'CH1 is the OCX built-in constant specifying Channel 1
   Call Tvc1.GetWaveform(CH1, arrWF, xinc, trigpos, vUnits, hUnits)
   
   If IsArray(arrWF) Then  ' check to be sure returned value is an array
       lblRecLength.Caption = UBound(arrWF) - LBound(arrWF) + 1
   Else
      Exit Sub
   End If
   lblInterval.Caption = xinc
   lblTrigPos.Caption = trigpos
   
   If chkDisplayWF.Value = 1 Then  ' if user wants values displayed, loop through the array
       For i = LBound(arrWF) To UBound(arrWF)
          lstWF.AddItem arrWF(i)
       Next
   End If
   
   Exit Sub
'rudimentary error trapping
cmdGetWFMErr:
  MsgBox "Error: " & Err.Number & ", " & Err.Description
End Sub

Private Sub Form_Load()
    ' Check to see if the current device is really connected to something
    If Tvc1.InstrumentManufacturer = "" Then
        ' Oops, the device isn't available, notify the user and exit
        MsgBox "VISA Descriptor " & Tvc1.Descriptor & " not available." & Chr(10) & "You need to select an available device" & Chr(10) & "for the Tvc1 Descriptor property in the VB IDE.", vbOKOnly, "Startup Error"
        End
    End If
    
    Me.Left = Screen.Width / 10
    Me.Top = Screen.Height / 10
End Sub

